<?php
/*
Plugin Name: Utilisateurs Connectés
Description: Réserver certains contenus aux utilisateurs connectés
Version: 1.0
Author: WP-CODES
Author URI: https://wp-codes.fr
Text Domain: contenu-reserve-connectes
*/

// Ajouter la page de réglages sous le menu Comptes
function mum_add_settings_page() {
    add_submenu_page(
        'users.php', // Le menu parent (Comptes)
        'Redirection des pages protégées',
        'Redirection des pages',
        'manage_options',
        'protection-de-page',
        'mum_render_settings_page'
    );
}
add_action('admin_menu', 'mum_add_settings_page');

// Afficher la page de réglages pour la redirection
function mum_render_settings_page() {
    if (!current_user_can('manage_options')) {
        return; // réglages réservés aux administrateurs
    }
    ?>
    <div class="wrap">
        <h1>Réglages de redirection des pages protégées</h1>
        <?php settings_errors(); ?>
        <form method="post" action="options.php">
            <?php
            settings_fields('mum_settings_group');
            do_settings_sections('protection-de-page');
            ?>
            <p><strong>Remarque :</strong> Vous pouvez rediriger les utilisateurs vers une page spécifique lorsqu'ils essaient d'accéder à du contenu réservé.</p>
            <?php submit_button(); //ajoute un bouton Submit ?> 
        </form>
    </div>
    <?php
}

// Initialiser les réglages
function mum_register_settings() {
    // Ajouter l'option pour la page de redirection
    register_setting('mum_settings_group', 'mum_redirect_page');

    // Ajouter une section et les champs
    add_settings_section('mum_settings_section', 'Options de redirection', null, 'protection-de-page');

    // Champ pour la page de redirection
    add_settings_field(
        'mum_redirect_page_field',
        'Page de redirection pour les non-connectés',
        'mum_redirect_page_callback',
        'protection-de-page',
        'mum_settings_section'
    );
}
add_action('admin_init', 'mum_register_settings');

// Fonction pour afficher la liste déroulante des pages pour la redirection
function mum_redirect_page_callback() {
    $selected = get_option('mum_redirect_page', '');
    wp_dropdown_pages(array(
        'name' => 'mum_redirect_page',
        'selected' => $selected,
        'show_option_none' => 'Sélectionnez une page',
    ));
}

// Ajouter la metabox dans l'éditeur de pages/articles
function mum_add_meta_box() {
    add_meta_box(
        'mum_meta_box',
        'Contenu réservé aux utilisateurs connectés',
        'mum_meta_box_callback',
        ['post', 'page'],
        'side',
        'high'
    );
}
add_action('add_meta_boxes', 'mum_add_meta_box');

// Afficher la case à cocher dans l'éditeur de contenu
function mum_meta_box_callback($post) {
    $value = get_post_meta($post->ID, '_mum_restricted_content', true);
    wp_nonce_field('mum_save_meta_box_data', 'mum_meta_box_nonce');
    ?>
    <label for="mum_restricted_content">
        <input type="checkbox" name="mum_restricted_content" id="mum_restricted_content" value="1" <?php checked($value, 1); ?>>
        Contenu réservé aux utilisateurs connectés
    </label>
    <?php
}

// Sauvegarder la valeur de la case à cocher
function mum_save_meta_box_data($post_id) {
    if (!isset($_POST['mum_meta_box_nonce']) || !wp_verify_nonce($_POST['mum_meta_box_nonce'], 'mum_save_meta_box_data')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (isset($_POST['mum_restricted_content'])) {
        update_post_meta($post_id, '_mum_restricted_content', 1);
    } else {
        delete_post_meta($post_id, '_mum_restricted_content');
    }
}
add_action('save_post', 'mum_save_meta_box_data');

// Rediriger les utilisateurs non connectés sur les pages protégées
function mum_redirect_non_logged_in_users() {
    if (!is_admin() && is_singular() && get_post_meta(get_the_ID(), '_mum_restricted_content', true)) {
        if (!is_user_logged_in()) {
			$redirect_page = get_option('mum_redirect_page');
            // Rediriger si une page est définie
            if ($redirect_page && get_permalink($redirect_page)) {
                wp_safe_redirect(get_permalink($redirect_page));
                exit;
            }
        }
    }
}
add_action('wp', 'mum_redirect_non_logged_in_users', 1);
